<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GalleryCategory extends Model 
{

    protected $table = 'gallery_categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function site()
    {
        return $this->hasOne('App\Model\Site');
    }

    public function user()
    {
        return $this->hasOne('App\User');
    }

    public function galleries()
    {
        return $this->hasMany('App\Model\Gallery', 'category_id', 'id');
    }

}